﻿Public Class Camera

    Public Property AvatarHeadOffset As Vector3
    Public Property TargetOffset As Vector3
    Public Property ViewMatrix As Matrix
    Public Property ProjectionMatrix As Matrix
    Public Property NearClip As Single = 1.0F
    Public Property FarClip As Single = 1000.0F
    Public Property ViewAngle As Single = 45.0F

    Sub New()
        Me.AvatarHeadOffset = New Vector3(0, 7, 0)
        Me.TargetOffset = New Vector3(0, 5, 15)
        Me.ViewMatrix = Matrix.Identity
        Me.ProjectionMatrix = Matrix.Identity
    End Sub

    Public Property PitchAngle As Single = 0.0F
    Public Property UPDirection As Vector3 = Vector3.Zero

    Public Sub Update(avatarYaw As Single, position As Vector3, aspectRatio As Single, mouseState As MouseState)
        Dim rotationMatrixY As Matrix = Matrix.CreateRotationY(avatarYaw)
        Dim transformedheadOffset As Vector3 = Vector3.Transform(AvatarHeadOffset, rotationMatrixY)
        Dim transformedReference As Vector3 = Vector3.Transform(TargetOffset, rotationMatrixY)


        Dim cameraPosition As Vector3 = position + transformedheadOffset
        Dim cameraTarget As Vector3 = position + transformedReference

        'Calculate the camera's view and projection 
        'matrices based on current values.
        Me.ViewMatrix = Matrix.CreateLookAt(cameraPosition, cameraTarget, Vector3.Up)
        Me.ProjectionMatrix = Matrix.CreatePerspectiveFieldOfView(MathHelper.ToRadians(Me.ViewAngle), aspectRatio, Me.NearClip, Me.FarClip)
    End Sub

End Class
